from .. import Provider as CompanyProvider


class Provider(CompanyProvider):
    """
    Implement company provider for ``bn_BD`` locale.
    Sources of companies:
        - https://en.wikipedia.org/wiki/List_of_companies_of_Bangladesh
    """

    companies = (
        "প্রাণ-আরএফএল গ্রুপ",
        "আকিজ গ্রুপ",
        "মেঘনা গ্রুপ অব ইন্ডাস্ট্রিজ",
        "বসুন্ধরা গ্রুপ",
        "ইস্পাহানি গ্রুপ",
        "বাংলাদেশ মেশিন টুলস ফ্যাক্টরী",
        "প্রগতি",
        "ইউএস-বাংলা এয়ারলাইন্স",
        "বিমান বাংলাদেশ এয়ারলাইনস",
        "রিজেন্ট এয়ারওয়েজ",
        "ইউনাইটেড এয়ারওয়েজ",
        "নভোএয়ার",
        "বেক্সিমকো গ্রুপ",
        "নাভানা গ্ৰুপ",
        "স্কয়ার গ্রুপ",
        "ট্রান্সকম গ্রুপ",
        "বেঙ্গল গ্রুপ",
        "যমুনা গ্রুপ",
        "নাসির গ্রুপ",
        "ট্রান্সকম ডিজিটাল",
        "স্কয়ার ইলেকট্রনিক্স",
        "রহিম আফরোজ",
        "ওয়ালটন",
        "বাংলাদেশ ব্যাংক",
        "অগ্রণী ব্যাংক",
        "জনতা ব্যাংক",
        "রূপালী ব্যাংক",
        "সোনালী ব্যাংক",
        "বাংলাদেশ ডেভেলপমেন্ট ব্যাংক লিমিটেড",
        "বেসিক ব্যাংক লিমিটেড",
        "আইএফআইসি ব্যাংক লিমিটেড",
        "ইউনাইটেড কমার্শিয়াল ব্যাংক লিমিটেড",
        "ইস্টার্ন ব্যাংক লিমিটেড",
        "উত্তরা ব্যাংক",
        "এনআরবি কমার্শিয়াল ব্যাংক লিমিটেড",
        "এনআরবি গ্লোবাল ব্যাংক লিমিটেড",
        "এনআরবি ব্যাংক লিমিটেড",
        "এবি ব্যাংক লিমিটেড",
        "এনসিসি ব্যাংক লিমিটেড",
        "ওয়ান ব্যাংক লিমিটেড",
        "ট্রাস্ট ব্যাংক লিমিটেড",
        "ডাচ-বাংলা ব্যাংক লিমিটেড",
        "দি ফারমার্স ব্যাংক লিমিটেড",
        "ন্যাশনাল ব্যাংক লিমিটেড",
        "ঢাকা ব্যাংক লিমিটেড",
        "পূবালী ব্যাংক লিমিটেড",
        "প্রাইম ব্যাংক লিমিটেড",
        "প্রিমিয়ার ব্যাংক লিমিটেড",
        "বাংলাদেশ কমার্স ব্যাংক লিমিটেড",
        "ব্র্যাক ব্যাংক লিমিটেড",
        "ব্যাংক এশিয়া লিমিটেড",
        "মধুমতি ব্যাংক লিমিটেড",
        "মার্কেন্টাইল ব্যাংক লিমিটেড",
        "মিউচুয়াল ট্রাস্ট ব্যাংক",
        "মিডল্যান্ড ব্যাংক লিমিটেড",
        "মেঘনা ব্যাংক লিমিটেড",
        "যমুনা ব্যাংক লিমিটেড",
        "সাউথ ইস্ট ব্যাংক লিমিটেড",
        "সাউথ বাংলা এগ্রিকালচার এন্ড কমার্স ব্যাংক লিমিটেড",
        "সিটি ব্যাংক লিমিটেড",
        "সীমান্ত ব্যাংক",
        "স্ট্যান্ডার্ড ব্যাংক লিমিটেড",
        "আইসিবি ইসলামিক ব্যাংক লিমিটেড",
        "আল-আরাফাহ ইসলামী ব্যাংক লিমিটেড",
        "ইউনিয়ন ব্যাংক লিমিটেড",
        "ইসলামী ব্যাংক বাংলাদেশ লিমিটেড",
        "এক্সিম ব্যাংক",
        "ফার্স্ট সিকিউরিটিজ ইসলামী ব্যাংক লিমিটেড",
        "শাহ্‌জালাল ইসলামী ব্যাংক লিমিটেড",
        "সোশ্যাইল ইসলামী ব্যাংক লিমিটেড",
        "এইচএসবিসি",
        "ওরি ব্যাংক",
        "কমার্শিয়াল ব্যাংক অব সিলন",
        "ন্যাশনাল ব্যাংক অব পাকিস্তান",
        "ব্যাংক আলফালাহ্",
        "ভারতীয় স্টেট ব্যাংক",
        "সিটিব্যাংক এনএ",
        "স্ট্যান্ডার্ড চার্টার্ড ব্যাংক লিমিটেড",
        "হাবিব ব্যাংক লিমিটেড",
        "বাংলাদেশ কৃষি ব্যাংক",
        "রাজশাহী কৃষি উন্নয়ন ব্যাংক",
        "আনসার-ভিডিপি উন্নয়ন ব্যাংক",
        "কর্মসংস্থান ব্যাংক",
        "গ্রামীণ ব্যাংক",
        "পল্লী সঞ্চয় ব্যাংক",
        "জুবিলী ব্যাংক",
        "প্রবাসী কল্যাণ ব্যাংক",
        "রাইজ আপ ল্যাবস",
        "এটিএন বাংলা",
        "বাংলাভিশন",
        "চ্যানেল আই (ইমপ্রেস টেলেফিল্ম লিমিটেড/চ্যানেল)",
        "এনটিভি (বাংলাদেশ)",
        "আরটিভি (বাংলাদেশ)",
        "দেশ টিভি",
        "ইন্ডিপেন্ডেন্ট টেলিভিশন",
        "দৈনিক প্রথম আলো",
        "দৈনিক ইত্তেফাক",
        "দৈনিক ভোরের কাগজ",
        "জাজ মাল্টিমিডিয়া",
        "নয়ন-আপন প্রোডাকশন",
        "প্যানারোমা মুভিজ",
        "এসকে ফিল্মস",
        "বেক্সিমকো ফার্মাসিউটিক্যালস",
        "ইনসেপ্টা ফার্মাসিউটিক্যালস লিমিটেড",
        "স্কয়ার ফার্মাসিটিক্যাল",
        "অপসোনিন ফার্মা লিমিটেড",
        "একমি ল্যাবরেটরিজ লিমিটেড",
        "বাংলাদেশ শিপিং কর্পোরেশন",
        "ডকইয়ার্ড অ্যান্ড ইঞ্জিনিয়ারিং ওয়ার্কস লিমিটেড",
        "এফএমসি ডকইয়ার্ড",
        "গ্রামীণফোন",
        "টেলিটক",
        "এয়ারটেল (বাংলাদেশ)",
        "বাংলালিংক",
        "রবি",
        "বাংলাদেশ পাওয়ার গ্রিড কোম্পানি",
        "ইউনাইটেড কমিউনিকেশন সার্ভিস",
    )

    company_suffixes = (
        "ইনকর্পোরেটেড",
        "কর্পোরেশন",
        "এন্ড সন্স",
        "এন্ড ব্রাদার্স",
        "এলএলসি",
        "গ্রুপ",
        "গ্রুপ অফ কোম্পানিজ",
        "পিএলসি",
        "লিমিটেড",
        "প্রাইভেট লিমিটেড",
        "এন্টারপ্রাইজ",
    )

    catch_phrase_words = (
        (
            "অভিযোজিত",
            "উন্নত",
            "উন্নীত",
            "আত্তীকরণ",
            "স্বয়ংক্রিয়",
            "সুষম",
            "ব্যবসা কেন্দ্রিক",
            "কেন্দ্রীভূত",
            "ক্লোন করা",
            "উপযুক্ত",
            "কনফিগারযোগ্য",
            "ক্রস-গ্রুপ",
            "ক্রস-প্ল্যাটফর্ম",
            "গ্রাহকের দৃষ্টি নিবদ্ধ",
            "কাস্টমাইজযোগ্য",
            "বিকেন্দ্রীভূত",
            "ডি-ইঞ্জিনিয়ারড",
            "বিকশিত",
            "ডিজিটাইজড",
            "বিতরণ করা",
            "বৈচিত্র্য",
            "নিম্ন আকারের",
            "উন্নত",
            "এন্টারপ্রাইজ-ওয়াইড",
            "অর্গোনমিক",
            "এক্সক্লুসিভ",
            "প্রসারিত",
            "সম্প্রসারিত",
            "মুখোমুখি",
            "ফোকাসড",
            "সামনের লাইন",
            "সম্পূর্ণ কনফিগারযোগ্য",
            "ফাংশন-ভিত্তিক",
            "মৌলিক",
            "ভবিষ্যত-প্রমাণ",
            "তৃণমূল",
            "অনুভূমিক",
            "বাস্তবায়িত",
            "উদ্ভাবনী",
            "সমন্বিত",
            "স্বজ্ঞাত",
            "বিপরীত",
            "পরিচালিত",
            "বাধ্যতামূলক",
            "পর্যবেক্ষণ করা",
            "মাল্টি-চ্যানেলযুক্ত",
            "মাল্টি-পার্শ্বিক",
            "মাল্টি লেয়ারড",
            "মাল্টি টায়ার্ড",
            "নেটওয়ার্ক করা",
            "বস্তু ভিত্তিক",
            "ওপেন আর্কিটেক্টেড",
            "মুক্ত উৎস",
            "অপারেটিভ",
            "অপ্টিমাইজ করা",
            "ঐচ্ছিক",
            "জৈব",
            "সংগঠিত",
            "অধ্যবসায়ী",
            "অস্থির",
            "পর্যায়ক্রমে",
            "পোলারাইজড",
            "প্রাক-অনুভব",
            "প্রোঅ্যাকটিভ",
            "লাভ কেন্দ্রিক",
            "গভীর",
            "প্রোগ্রামেবল",
            "প্রগতিশীল",
            "পাবলিক-কী",
            "মান-কেন্দ্রিক",
            "প্রতিক্রিয়াশীল",
            "পুনরায় সংগঠিত",
            "পুনরায় প্রাসঙ্গিক",
            "পুনঃপ্রকৌশলী",
            "কমানো",
            "বিপরীত প্রকৌশলী",
            "ডান মাপের",
            "বলিষ্ঠ",
            "বিরামহীন",
            "সুরক্ষিত",
            "স্ব-সক্ষম",
            "ভাগযোগ্য",
            "একা একা",
            "প্রবাহিত",
            "পরিবর্তনযোগ্য",
            "সিঙ্ক্রোনাইজড",
            "সিনারজিস্টিক",
            "সমন্বিত",
            "দল ভিত্তিক",
            "মোট",
            "ট্রিপল-বাফার",
            "সর্বজনীন",
            "উপরের আকার",
            "আপগ্রেডযোগ্য",
            "ব্যবহারকারীকেন্দ্রিক",
            "ব্যবহারকারী বান্ধব",
            "বহুমুখী",
            "অপার্থিব",
            "দূরদর্শী",
            "দৃষ্টি-ভিত্তিক",
        ),
        (
            "২৪ ঘন্টা",
            "২৪/৭",
            "তৃতীয় প্রজন্ম",
            "৪র্থ প্রজন্ম",
            "৫ম প্রজন্ম",
            "ষষ্ঠ প্রজন্ম",
            "কার্যকর",
            "বিশ্লেষণ",
            "অসমমিত",
            "অসিঙ্ক্রোনাস",
            "মনোভাব-ভিত্তিক",
            "পটভূমি",
            "ব্যান্ডউইথ-নিরীক্ষণ করা",
            "দ্বিমুখী",
            "বিভক্ত",
            "শেষের সারি",
            "স্বচ্ছ চিন্তা",
            "ক্লায়েন্ট-চালিত",
            "ক্লায়েন্ট সার্ভার",
            "সুসংগত",
            "সমন্বিত",
            "যৌগিক",
            "প্রসঙ্গ-সংবেদনশীল",
            "প্রসঙ্গ-ভিত্তিক",
            "সামগ্রী ভিত্তিক",
            "নিবেদিত",
            "চাহিদা চালিত",
            "শিক্ষামূলক",
            "দিকনির্দেশক",
            "বিচ্ছিন্ন",
            "বিচ্ছিন্ন",
            "গতিশীল",
            "পরিবেশ কেন্দ্রিক",
            "শক্তিকরণ",
            "বেষ্টিত",
            "সম-কিলড",
            "কার্যনির্বাহী",
            "স্পষ্ট",
            "প্রবাহিত",
            "ভ্রান্তি সহিষ্ণুতা",
            "পুরোভূমি",
            "নতুন চিন্তা",
            "পূর্ণ পরিসরে",
            "বিশ্বব্যাপী",
            "গ্রিড-সক্রিয়",
            "হিউরিস্টিক",
            "উচ্চস্তর",
            "সম্পূর্ণ",
            "সমজাতীয়",
            "মানব সম্পদ",
            "হাইব্রিড",
            "প্রভাবমূলক",
            "ক্রমবর্ধমান",
            "অভেদ্য",
            "ইন্টারেক্টিভ",
            "মধ্যবর্তী",
            "নেতৃস্থানীয় প্রান্ত",
            "স্থানীয়",
            "লজিস্টিক",
            "সর্বোচ্চ করা",
            "পদ্ধতিগত",
            "মিশন-সমালোচনা",
            "মুঠোফোন",
            "মডুলার",
            "প্রেরণাদায়ক",
            "মাল্টিমিডিয়া",
            "মাল্টি-স্টেট",
            "মাল্টি টাস্কিং",
            "জাতীয়",
            "প্রয়োজন ভিত্তিক",
            "নিরপেক্ষ",
            "পরবর্তী প্রজন্ম",
            "অস্থির",
            "অবজেক্ট ওরিয়েন্টেড",
            "অনুকূল",
            "অপ্টিমাইজ করা",
            "আমূল",
            "প্রকৃত সময়",
            "পারস্পরিক",
            "আঞ্চলিক",
            "প্রতিক্রিয়াশীল",
            "স্কেলযোগ্য",
            "মাধ্যমিক",
            "সমাধান ভিত্তিক",
            "স্থিতিশীল",
            "স্থির",
            "পদ্ধতিগত",
            "পদ্ধতিগত",
            "সিস্টেম-যোগ্য",
            "মূর্ত",
            "তৃতীয়",
            "ক্রান্তিকালীন",
            "ইউনিফর্ম",
            "উর্ধ্বমুখী প্রবণতা",
            "ব্যবহারকারীর মুখোমুখি",
            "মূল্য সংযোজন",
            "ওয়েব-সক্ষম",
            "ভালভাবে পরিমিত",
            "শূন্য প্রশাসন",
            "শূন্য ত্রুটি",
            "শূন্য সহনশীলতা",
        ),
        (
            "ক্ষমতা",
            "অ্যাক্সেস",
            "অ্যাডাপ্টার",
            "অ্যালগরিদম",
            "জোট",
            "বিশ্লেষক",
            "আবেদন",
            "পন্থা",
            "স্থাপত্য",
            "আর্কাইভ",
            "কৃত্রিম বুদ্ধিমত্তা",
            "অ্যারে",
            "মনোভাব",
            "মাপকাঠি",
            "বাজেটারি ব্যবস্থাপনা",
            "ক্ষমতা",
            "ক্ষমতা",
            "চ্যালেঞ্জ",
            "সার্কিট",
            "সহযোগিতা",
            "জটিলতা",
            "ধারণা",
            "সমষ্টি",
            "কমার্জেন্সি",
            "মূল",
            "ক্রেতা বিশ্বস্ততা",
            "তথ্যশালা",
            "তথ্য ভাণ্ডার",
            "সংজ্ঞা",
            "অনুকরণ",
            "এনকোডিং",
            "জোড়া লাগানো",
            "এক্সট্রানেট",
            "ফার্মওয়্যার",
            "নমনীয়তা",
            "ফোকাস গ্রুপ",
            "পূর্বাভাস",
            "ফ্রেম",
            "ফ্রেমওয়ার্ক",
            "ফাংশন",
            "কার্যকারিতা",
            "গ্রাফিক ইন্টারফেস",
            "গ্রুপওয়্যার",
            "গ্রাফিকাল ইউজার ইন্টারফেস",
            "হার্ডওয়্যার",
            "সাহায্য ডেস্ক",
            "শ্রেণীবিন্যাস",
            "হাব",
            "বাস্তবায়ন",
            "তথ্য মিডিয়ার",
            "অবকাঠামো",
            "উদ্যোগ",
            "স্থাপন",
            "নির্দেশনাবলী",
            "ইন্টারফেস",
            "ইন্টারনেট সমাধান",
            "ইন্ট্রানেট",
            "জ্ঞান ব্যবহারকারী",
            "জ্ঞানভিত্তিক",
            "স্থানীয় নেটওয়ার্ক",
            "লিভারেজ",
            "ম্যাট্রিস",
            "ম্যাট্রিক্স",
            "পদ্ধতি",
            "মিডলওয়্যার",
            "অভিবাসন",
            "মডেল",
            "মডারেটর",
            "পর্যবেক্ষণ",
            "স্থগিত",
            "নিউরাল-নেট",
            "উন্মুক্ত স্থাপত্য",
            "মুক্ত ব্যবস্থা",
            "অর্কেস্ট্রেশন",
            "দৃষ্টান্ত",
            "সমান্তরালতা",
            "নীতি",
            "পোর্টাল",
            "মূল্যের কাঠামো",
            "প্রক্রিয়ার উন্নতি",
            "পণ্য",
            "প্রমোদ",
            "প্রকল্প",
            "প্রক্ষেপণ",
            "প্রটোকল",
            "সুরক্ষিত লাইন",
            "পরিষেবা ডেস্ক",
            "সফটওয়্যার",
            "সমাধান",
            "প্রমিতকরণ",
            "কৌশল",
            "গঠন",
            "সফলতা",
            "উপরকাঠামো",
            "সমর্থন",
            "সিনার্জি",
            "সিস্টেম ইঞ্জিন",
            "বিশেষ কর্মীদল",
            "থ্রুপুট",
            "সময়সীমা",
            "টুলসেট",
            "ব্যবহার",
            "ওয়েবসাইট",
            "শ্রমিক",
        ),
    )

    bsWords = (
        (
            "বাস্তবায়ন",
            "ব্যবহার করুন",
            "একীকরণ",
            "স্ট্রিমলাইন",
            "অপ্টিমাইজ করুন",
            "বিকশিত",
            "রূপান্তর",
            "আলিঙ্গন",
            "সক্ষম",
            "অর্কেস্ট্রেট",
            "লিভারেজ",
            "পুনরাবিষ্কার",
            "সমষ্টি",
            "স্থপতি",
            "বর্ধিত করা",
            "উদ্দীপনা",
            "রূপ",
            "ক্ষমতায়ন",
            "কল্পনাকারী",
            "নগদীকরণ",
            "কাজে লাগান",
            "সহজতর করা",
            "জব্দ",
            "বিচ্ছিন্ন",
            "সমন্বয় করা",
            "কৌশল করা",
            "মোতায়েন",
            "ব্র্যান্ড",
            "বড়",
            "লক্ষ্য",
            "সিন্ডিকেট",
            "সংশ্লেষণ",
            "বিলি করা",
            "জাল",
            "ইনকিউবেট",
            "নিয়োগ",
            "সর্বোচ্চ করুন",
            "মাপকাঠি",
            "ত্বরান্বিত করা",
            "পুনরায় মধ্যবর্তী",
            "হোয়াইটবোর্ড",
            "ভিজ্যুয়ালাইজ",
            "পুনঃউদ্দেশ্য",
            "উদ্ভাবন",
            "স্কেল",
            "মুক্ত করা",
            "ড্রাইভ",
            "প্রসারিত করা",
            "প্রকৌশলী",
            "বিপ্লব",
            "উত্পন্ন করুন",
            "শোষণ",
            "পরিবর্তন",
            "ই-সক্ষম",
            "পুনরাবৃত্তি",
            "চাষ করা",
            "ম্যাট্রিক্স",
            "উৎপাদন করা",
            "পুনরায় সংজ্ঞায়িত করুন",
            "পুনরায় প্রাসঙ্গিককরণ",
        ),
        (
            "ক্লিক এবং মর্টার",
            "মূল্য সংযোজন",
            "উল্লম্ব",
            "সক্রিয়",
            "বলিষ্ঠ",
            "বিপ্লবী",
            "স্কেলযোগ্য",
            "নেতৃস্থানীয় প্রান্ত",
            "উদ্ভাবনী",
            "স্বজ্ঞাত",
            "কৌশলগত",
            "ই-ব্যবসা",
            "মিশন-সমালোচনা",
            "আঠালো",
            "একের পর এক",
            "24/7",
            "সর্বশেষ সীমা",
            "বিশ্বব্যাপী",
            "B2B",
            "B2C",
            "দানাদার",
            "ঘর্ষণহীন",
            "অপার্থিব",
            "ভাইরাল",
            "গতিশীল",
            "24/365",
            "সর্বোত্তম জাত",
            "হত্যাকারী",
            "চৌম্বকীয়",
            "রক্তপাতের প্রান্ত",
            "ওয়েব-সক্ষম",
            "ইন্টারেক্টিভ",
            "ডট-কম",
            "ব্যাক-এন্ড",
            "প্রকৃত সময়",
            "দক্ষ",
            "সামনের অংশ",
            "বিতরণ করা",
            "বিরামহীন",
            "সম্প্রসারণযোগ্য",
            "টার্ন-কি",
            "বিশ্বমানের",
            "মুক্ত উৎস",
            "ক্রস-প্ল্যাটফর্ম",
            "ক্রস-মিডিয়া",
            "সিনারজিস্টিক",
            "ইট-এন্ড-ক্লিক",
            "বাক্সের বাইরে",
            "এন্টারপ্রাইজ",
            "সমন্বিত",
            "প্রভাবমূলক",
            "বেতার",
            "স্বচ্ছ",
            "পরবর্তী প্রজন্ম",
            "অত্যাধুনিক",
            "ব্যবহারকারীকেন্দ্রিক",
            "দূরদর্শী",
            "কাস্টমাইজড",
            "সর্বব্যাপী",
            "প্লাগ-এন্ড-প্লে",
            "সহযোগী",
            "আবশ্যক",
            "সম্পূর্ণ",
            "ধনী",
        ),
        (
            "ঐকতান",
            "ওয়েব-প্রস্তুতি",
            "দৃষ্টান্ত",
            "বাজার",
            "অংশীদারিত্ব",
            "অবকাঠামো",
            "প্ল্যাটফর্ম",
            "উদ্যোগ",
            "চ্যানেল",
            "চোখের বল",
            "সম্প্রদায়",
            "ROI",
            "সমাধান",
            "ই-টেইলার",
            "ই-পরিষেবা",
            "অ্যাকশন-আইটেম",
            "পোর্টাল",
            "কুলুঙ্গি",
            "প্রযুক্তি",
            "সামগ্রী",
            "ঘূর্ণি",
            "সরবারহ শৃঙ্খল",
            "সম্মিলন",
            "সম্পর্ক",
            "স্থাপত্য",
            "ইন্টারফেস",
            "ই-মার্কেট",
            "ই-কমার্স",
            "সিস্টেম",
            "ব্যান্ডউইথ",
            "তথ্য মিডিয়ার",
            "মডেল",
            "মনের ভাগ",
            "প্রসবযোগ্য",
            "ব্যবহারকারী",
            "স্কিমাস",
            "নেটওয়ার্ক",
            "অ্যাপ্লিকেশন",
            "মেট্রিক্স",
            "ই-ব্যবসা",
            "কার্যকারিতা",
            "অভিজ্ঞতা",
            "ওয়েব সার্ভিস",
            "পদ্ধতি",
        ),
    )

    def company(self) -> str:
        """
        :example: 'ইস্পাহানি গ্রুপ'
        """
        return self.random_element(self.companies)
