/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.AffineTransform;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.svek.extremity.Extremity;

class ExtremityHalfArrow
extends Extremity {
    private final ULine line;
    private final ULine otherLine;
    private final XPoint2D contact;

    @Override
    public XPoint2D somePoint() {
        return this.contact;
    }

    public ExtremityHalfArrow(XPoint2D p1, double angle, XPoint2D center, int direction) {
        angle = this.manageround(angle);
        AffineTransform rotate = AffineTransform.getRotateInstance(angle + 1.5707963267948966);
        int xWing = 9;
        int yAperture = 4 * direction;
        XPoint2D other = new XPoint2D(-9.0, -yAperture);
        other = other.transform(rotate);
        this.contact = p1;
        this.line = new ULine(center.getX() - this.contact.getX(), center.getY() - this.contact.getY());
        this.otherLine = new ULine(other.getX(), other.getY());
    }

    public ExtremityHalfArrow(XPoint2D p0, double angle, int direction) {
        angle = this.manageround(angle);
        int xWing = 9;
        int yAperture = 4 * direction;
        this.contact = p0;
        XPoint2D other = new XPoint2D(-9.0, -yAperture).transform(AffineTransform.getRotateInstance(angle));
        XPoint2D other2 = new XPoint2D(-8.0, 0.0).transform(AffineTransform.getRotateInstance(angle));
        this.line = new ULine(other.getX(), other.getY());
        this.otherLine = new ULine(other2.getX(), other2.getY());
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(HColors.changeBack(ug));
        if (this.line != null && this.line.getLength() > 2.0) {
            UTranslate position = UTranslate.point(this.contact);
            ug.apply(position).draw(this.line);
            ug.apply(position).draw(this.otherLine);
        }
    }
}

