/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.misc;

import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI;

public class GlossyTaskPaneUI
extends BasicTaskPaneUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new GlossyTaskPaneUI();
    }

    @Override
    protected Border createPaneBorder() {
        return new GlossyPaneBorder();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getParent().getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, this.getRoundHeight(), jComponent.getWidth(), jComponent.getHeight() - this.getRoundHeight());
        }
        this.paint(graphics, jComponent);
    }

    class GlossyPaneBorder
    extends BasicTaskPaneUI.PaneBorder {
        GlossyPaneBorder() {
        }

        @Override
        protected void paintTitleBackground(JXTaskPane jXTaskPane, Graphics graphics) {
            if (jXTaskPane.isSpecial()) {
                graphics.setColor(this.specialTitleBackground);
                graphics.fillRoundRect(0, 0, jXTaskPane.getWidth(), GlossyTaskPaneUI.this.getRoundHeight() * 2, GlossyTaskPaneUI.this.getRoundHeight(), GlossyTaskPaneUI.this.getRoundHeight());
                graphics.fillRect(0, GlossyTaskPaneUI.this.getRoundHeight(), jXTaskPane.getWidth(), GlossyTaskPaneUI.this.getTitleHeight(jXTaskPane) - GlossyTaskPaneUI.this.getRoundHeight());
            } else {
                Paint paint = ((Graphics2D)graphics).getPaint();
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.titleBackgroundGradientStart, 0.0f, GlossyTaskPaneUI.this.getTitleHeight(jXTaskPane), this.titleBackgroundGradientEnd);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                ((Graphics2D)graphics).setPaint(gradientPaint);
                graphics.fillRoundRect(0, 0, jXTaskPane.getWidth(), GlossyTaskPaneUI.this.getRoundHeight() * 2, GlossyTaskPaneUI.this.getRoundHeight(), GlossyTaskPaneUI.this.getRoundHeight());
                graphics.fillRect(0, GlossyTaskPaneUI.this.getRoundHeight(), jXTaskPane.getWidth(), GlossyTaskPaneUI.this.getTitleHeight(jXTaskPane) - GlossyTaskPaneUI.this.getRoundHeight());
                ((Graphics2D)graphics).setPaint(paint);
            }
            graphics.setColor(this.borderColor);
            graphics.drawRoundRect(0, 0, jXTaskPane.getWidth() - 1, GlossyTaskPaneUI.this.getTitleHeight(jXTaskPane) + GlossyTaskPaneUI.this.getRoundHeight(), GlossyTaskPaneUI.this.getRoundHeight(), GlossyTaskPaneUI.this.getRoundHeight());
            graphics.drawLine(0, GlossyTaskPaneUI.this.getTitleHeight(jXTaskPane) - 1, jXTaskPane.getWidth(), GlossyTaskPaneUI.this.getTitleHeight(jXTaskPane) - 1);
        }

        @Override
        protected void paintExpandedControls(JXTaskPane jXTaskPane, Graphics graphics, int n, int n2, int n3, int n4) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintOvalAroundControls(jXTaskPane, graphics, n, n2, n3, n4);
            graphics.setColor(this.getPaintColor(jXTaskPane));
            this.paintChevronControls(jXTaskPane, graphics, n, n2, n3, n4);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        @Override
        protected boolean isMouseOverBorder() {
            return true;
        }
    }
}

