/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Combines two images in a checkerboard pattern.


CheckerBoardImageFilter takes two input images that must have the same dimension, size,
origin and spacing and produces an output image of the same size by
combining the pixels from the two input images in a checkerboard
pattern. This filter is commonly used for visually comparing two
images, in particular for evaluating the results of an image
registration process.

This filter is implemented as a multithreaded filter. It provides a
DynamicThreadedGenerateData() method for its implementation.
See:
 itk::simple::CheckerBoard for the procedural interface

 itk::CheckerBoardImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkCheckerBoardImageFilter.h
*/
public class CheckerBoardImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected CheckerBoardImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.CheckerBoardImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(CheckerBoardImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(CheckerBoardImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::CheckerBoardImageFilter::~CheckerBoardImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_CheckerBoardImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::CheckerBoardImageFilter::CheckerBoardImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  CheckerBoardImageFilter() {
    this(SimpleITKJNI.new_CheckerBoardImageFilter(), true);
  }

  /**
Self&amp; itk::simple::CheckerBoardImageFilter::SetCheckerPattern(uint32_t value)

Set the values of the CheckerPattern vector all to value

*/
public  void setCheckerPattern(VectorUInt32 CheckerPattern) {
    SimpleITKJNI.CheckerBoardImageFilter_setCheckerPattern__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(CheckerPattern), CheckerPattern);
  }

  /**
Self&amp; itk::simple::CheckerBoardImageFilter::SetCheckerPattern(uint32_t value)

Set the values of the CheckerPattern vector all to value

*/
public  void setCheckerPattern(long value) {
    SimpleITKJNI.CheckerBoardImageFilter_setCheckerPattern__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;uint32_t&gt; itk::simple::CheckerBoardImageFilter::GetCheckerPattern() const

Set/Get the checker pattern array, i.e. the number of checker boxes
per image dimension.

*/
public  VectorUInt32 getCheckerPattern() {
    return new VectorUInt32(SimpleITKJNI.CheckerBoardImageFilter_getCheckerPattern(swigCPtr, this), true);
  }

  /**
std::string itk::simple::CheckerBoardImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.CheckerBoardImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::CheckerBoardImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.CheckerBoardImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::CheckerBoardImageFilter::Execute(const Image &amp;image1, const Image &amp;image2)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.CheckerBoardImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

}
