/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.echosvg.css.engine.value.ColorValue;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import org.w3c.api.DOMSyntaxException;
import org.w3c.css.om.typed.CSSLCH;
import org.w3c.css.om.typed.CSSNumericValue;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public class LCHColorValue
extends ColorValue
implements CSSLCH {
    private static final long serialVersionUID = 1L;
    protected NumericValue l;
    protected NumericValue c;
    protected NumericValue h;

    public LCHColorValue(NumericValue l, NumericValue c, NumericValue h) throws DOMSyntaxException {
        this(l, c, h, SVGValueConstants.NUMBER_1);
    }

    public LCHColorValue(NumericValue l, NumericValue c, NumericValue h, NumericValue alpha) throws DOMSyntaxException {
        super(alpha);
        this.setL(l);
        this.setC(c);
        this.setH(h);
    }

    @Override
    public String getCSSColorSpace() {
        return "lch";
    }

    public String getCssText() {
        StringBuilder buf = new StringBuilder();
        buf.append("lch(").append(this.l.getCssText()).append(' ').append(this.c.getCssText()).append(' ').append(this.h.getCssText());
        if (!this.isOpaque()) {
            buf.append(' ').append(this.getAlpha().getCssText());
        }
        buf.append(')');
        return buf.toString();
    }

    public NumericValue getL() {
        return this.l;
    }

    public NumericValue getC() {
        return this.c;
    }

    public NumericValue getH() {
        return this.h;
    }

    public void setL(double lightness) {
        this.l = new FloatValue(2, (float)lightness);
        this.componentize(this.l);
        this.componentChanged(this.l);
    }

    public void setL(CSSNumericValue lightness) throws DOMSyntaxException {
        this.l = this.component(lightness);
        this.componentChanged(this.l);
    }

    private NumericValue component(CSSNumericValue c) throws DOMSyntaxException {
        NumericValue ch = (NumericValue)c;
        if (ch.getUnitType() != 2 && ch.getUnitType() != 0) {
            throw new DOMSyntaxException("LC component must be a number or percentage.");
        }
        if (ch.handler != null) {
            ch = ch.clone();
        }
        this.componentize(ch);
        return ch;
    }

    public void setC(double c) {
        this.c = new FloatValue(2, (float)c);
        this.componentize(this.c);
        this.componentChanged(this.c);
    }

    public void setC(CSSNumericValue c) throws DOMSyntaxException {
        this.c = this.component(c);
        this.componentChanged(this.c);
    }

    public void setH(double h) {
        this.h = new FloatValue(80, (float)h);
        this.componentize(this.h);
        this.componentChanged(this.h);
    }

    public void setH(CSSNumericValue h) throws DOMSyntaxException {
        this.h = this.hueComponent(h);
        this.componentChanged(this.h);
    }

    private NumericValue hueComponent(CSSNumericValue h) {
        NumericValue ch = (NumericValue)h;
        if (ch.getUnitType() != 0 && !CSSUnit.isAngleUnitType((short)ch.getUnitType())) {
            throw new DOMSyntaxException("Hue component must be a number or angle.");
        }
        if (ch.handler != null) {
            ch = ch.clone();
        }
        this.componentize(ch);
        return ch;
    }

    @Override
    public int getLength() throws DOMException {
        return 4;
    }

    @Override
    public Value item(int index) throws DOMException {
        switch (index) {
            case 0: {
                return this.getL();
            }
            case 1: {
                return this.getC();
            }
            case 2: {
                return this.getH();
            }
            case 3: {
                return this.getAlpha();
            }
        }
        return null;
    }

    @Override
    public LCHColorValue clone() {
        LCHColorValue clon = (LCHColorValue)super.clone();
        clon.l = this.l.clone();
        clon.c = this.c.clone();
        clon.h = this.h.clone();
        return clon;
    }
}

