/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.DynamicConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.ModuleConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.PackageConstant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.util.ArrayUtil;

class ComparableConstant
extends SimplifiedVisitor
implements Comparable,
ConstantVisitor {
    private static final int[] PRIORITIES = new int[22];
    private final Clazz clazz;
    private final int thisIndex;
    private final Constant thisConstant;
    private Constant otherConstant;
    private int result;

    public ComparableConstant(Clazz clazz, int index, Constant constant) {
        this.clazz = clazz;
        this.thisIndex = index;
        this.thisConstant = constant;
    }

    public int getIndex() {
        return this.thisIndex;
    }

    public Constant getConstant() {
        return this.thisConstant;
    }

    public int compareTo(Object other) {
        int otherTag;
        ComparableConstant otherComparableConstant = (ComparableConstant)other;
        this.otherConstant = otherComparableConstant.thisConstant;
        if (this.thisConstant == this.otherConstant) {
            int otherIndex = otherComparableConstant.thisIndex;
            return Integer.compare(this.thisIndex, otherIndex);
        }
        int thisTag = this.thisConstant.getTag();
        if (thisTag != (otherTag = this.otherConstant.getTag())) {
            return Integer.compare(PRIORITIES[thisTag], PRIORITIES[otherTag]);
        }
        this.thisConstant.accept(this.clazz, this);
        return this.result;
    }

    @Override
    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        this.result = Integer.compare(integerConstant.getValue(), ((IntegerConstant)this.otherConstant).getValue());
    }

    @Override
    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        this.result = Long.compare(longConstant.getValue(), ((LongConstant)this.otherConstant).getValue());
    }

    @Override
    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        this.result = Float.compare(floatConstant.getValue(), ((FloatConstant)this.otherConstant).getValue());
    }

    @Override
    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        this.result = Double.compare(doubleConstant.getValue(), ((DoubleConstant)this.otherConstant).getValue());
    }

    @Override
    public void visitPrimitiveArrayConstant(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant) {
        char otherPrimitiveType;
        PrimitiveArrayConstant otherPrimitiveArrayConstant = (PrimitiveArrayConstant)this.otherConstant;
        char primitiveType = primitiveArrayConstant.getPrimitiveType();
        if (primitiveType != (otherPrimitiveType = otherPrimitiveArrayConstant.getPrimitiveType())) {
            this.result = Integer.compare(primitiveType, otherPrimitiveType);
        } else {
            Object values = primitiveArrayConstant.getValues();
            Object otherValues = otherPrimitiveArrayConstant.getValues();
            this.result = values instanceof boolean[] ? ArrayUtil.compare((boolean[])values, ((boolean[])values).length, (boolean[])otherValues, ((boolean[])otherValues).length) : (values instanceof byte[] ? ArrayUtil.compare((byte[])values, ((byte[])values).length, (byte[])otherValues, ((byte[])otherValues).length) : (values instanceof char[] ? ArrayUtil.compare((char[])values, ((char[])values).length, (char[])otherValues, ((char[])otherValues).length) : (values instanceof short[] ? ArrayUtil.compare((short[])values, ((short[])values).length, (short[])otherValues, ((short[])otherValues).length) : (values instanceof int[] ? ArrayUtil.compare((int[])values, ((int[])values).length, (int[])otherValues, ((int[])otherValues).length) : (values instanceof float[] ? ArrayUtil.compare((float[])values, ((float[])values).length, (float[])otherValues, ((float[])otherValues).length) : (values instanceof long[] ? ArrayUtil.compare((long[])values, ((long[])values).length, (long[])otherValues, ((long[])otherValues).length) : ArrayUtil.compare((double[])values, ((double[])values).length, (double[])otherValues, ((double[])otherValues).length)))))));
        }
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.result = stringConstant.getString(clazz).compareTo(((StringConstant)this.otherConstant).getString(clazz));
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        this.result = utf8Constant.getString().compareTo(((Utf8Constant)this.otherConstant).getString());
    }

    @Override
    public void visitDynamicConstant(Clazz clazz, DynamicConstant dynamicConstant) {
        int otherIndex;
        DynamicConstant otherDynamicConstant = (DynamicConstant)this.otherConstant;
        int index = dynamicConstant.getBootstrapMethodAttributeIndex();
        this.result = index < (otherIndex = otherDynamicConstant.getBootstrapMethodAttributeIndex()) ? -1 : (index > otherIndex ? 1 : this.compare(dynamicConstant.getName(clazz), dynamicConstant.getType(clazz), otherDynamicConstant.getName(clazz), otherDynamicConstant.getType(clazz)));
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        int otherIndex;
        InvokeDynamicConstant otherInvokeDynamicConstant = (InvokeDynamicConstant)this.otherConstant;
        int index = invokeDynamicConstant.getBootstrapMethodAttributeIndex();
        this.result = index < (otherIndex = otherInvokeDynamicConstant.getBootstrapMethodAttributeIndex()) ? -1 : (index > otherIndex ? 1 : this.compare(invokeDynamicConstant.getName(clazz), invokeDynamicConstant.getType(clazz), otherInvokeDynamicConstant.getName(clazz), otherInvokeDynamicConstant.getType(clazz)));
    }

    @Override
    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        int otherKind;
        MethodHandleConstant otherMethodHandleConstant = (MethodHandleConstant)this.otherConstant;
        int kind = methodHandleConstant.getReferenceKind();
        this.result = kind < (otherKind = otherMethodHandleConstant.getReferenceKind()) ? -1 : (kind > otherKind ? 1 : this.compare(methodHandleConstant.getClassName(clazz), methodHandleConstant.getName(clazz), methodHandleConstant.getType(clazz), otherMethodHandleConstant.getClassName(clazz), otherMethodHandleConstant.getName(clazz), otherMethodHandleConstant.getType(clazz)));
    }

    @Override
    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        RefConstant otherRefConstant = (RefConstant)this.otherConstant;
        this.result = this.compare(refConstant.getClassName(clazz), refConstant.getName(clazz), refConstant.getType(clazz), otherRefConstant.getClassName(clazz), otherRefConstant.getName(clazz), otherRefConstant.getType(clazz));
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.result = classConstant.getName(clazz).compareTo(((ClassConstant)this.otherConstant).getName(clazz));
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant MethodTypeConstant2) {
        MethodTypeConstant otherMethodTypeConstant = (MethodTypeConstant)this.otherConstant;
        this.result = MethodTypeConstant2.getType(clazz).compareTo(otherMethodTypeConstant.getType(clazz));
    }

    @Override
    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        NameAndTypeConstant otherNameAndTypeConstant = (NameAndTypeConstant)this.otherConstant;
        this.result = this.compare(nameAndTypeConstant.getName(clazz), nameAndTypeConstant.getType(clazz), otherNameAndTypeConstant.getName(clazz), otherNameAndTypeConstant.getType(clazz));
    }

    @Override
    public void visitModuleConstant(Clazz clazz, ModuleConstant moduleConstant) {
        this.result = moduleConstant.getName(clazz).compareTo(((ModuleConstant)this.otherConstant).getName(clazz));
    }

    @Override
    public void visitPackageConstant(Clazz clazz, PackageConstant packageConstant) {
        this.result = packageConstant.getName(clazz).compareTo(((PackageConstant)this.otherConstant).getName(clazz));
    }

    public boolean equals(Object other) {
        return other != null && this.getClass().equals(other.getClass()) && this.getConstant().getClass().equals(((ComparableConstant)other).getConstant().getClass()) && this.compareTo(other) == 0;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private int compare(String string1a, String string1b, String string2a, String string2b) {
        int comparison = string1a.compareTo(string2a);
        return comparison != 0 ? comparison : string1b.compareTo(string2b);
    }

    private int compare(String string1a, String string1b, String string1c, String string2a, String string2b, String string2c) {
        int comparison = string1a.compareTo(string2a);
        return comparison != 0 ? comparison : ((comparison = string1b.compareTo(string2b)) != 0 ? comparison : string1c.compareTo(string2c));
    }

    static {
        ComparableConstant.PRIORITIES[3] = 0;
        ComparableConstant.PRIORITIES[4] = 1;
        ComparableConstant.PRIORITIES[8] = 2;
        ComparableConstant.PRIORITIES[7] = 3;
        ComparableConstant.PRIORITIES[5] = 4;
        ComparableConstant.PRIORITIES[6] = 5;
        ComparableConstant.PRIORITIES[9] = 6;
        ComparableConstant.PRIORITIES[10] = 7;
        ComparableConstant.PRIORITIES[11] = 8;
        ComparableConstant.PRIORITIES[17] = 9;
        ComparableConstant.PRIORITIES[18] = 10;
        ComparableConstant.PRIORITIES[15] = 11;
        ComparableConstant.PRIORITIES[12] = 12;
        ComparableConstant.PRIORITIES[16] = 13;
        ComparableConstant.PRIORITIES[19] = 14;
        ComparableConstant.PRIORITIES[20] = 15;
        ComparableConstant.PRIORITIES[1] = 16;
        ComparableConstant.PRIORITIES[21] = 17;
    }
}

